// ==UserScript==
// @name         5ch 自動更新
// @namespace    https://example.com/
// @version      3.3.12
// @description  5chスレの新着レスをリアルタイム追加。純正風スタイル対応、ON/OFF切替付き。
// @match        *://*.5ch.net/test/read.cgi/*
// @grant        none
// ==/UserScript==

(function () {
    'use strict';

    if (window.top !== window.self) return;

    const autoStart = true; // 初期状態：trueでページロード時起動状態
    const timer = 5; // 更新頻度（秒）

    const EXISTING_TOP_MARGIN_HEIGHT = 0;
    const EXISTING_BOTTOM_PADDING_SIZE = '0px';
    const NEW_TOP_MARGIN_HEIGHT = 0;
    const NEW_BOTTOM_PADDING_SIZE = '0px';
    const QUICK_REPLY_MARGIN = '0px';

    const statusDiv = document.createElement('div');
    statusDiv.style.position = 'fixed';
    statusDiv.style.bottom = '14px';
    statusDiv.style.left = '10px';
    statusDiv.style.padding = '6px 10px';
    statusDiv.style.backgroundColor = 'rgba(0,0,0,0.7)';
    statusDiv.style.opacity = 0.3;
    statusDiv.style.color = 'white';
    statusDiv.style.fontSize = '14px';
    statusDiv.style.borderRadius = '4px';
    statusDiv.style.zIndex = 99999;
    statusDiv.style.cursor = 'pointer';
    statusDiv.title = 'クリックでON/OFF';
    statusDiv.textContent = '[自動更新停止中]';
    document.body.appendChild(statusDiv);

    let isRunning = false;
    let timerId;

    let lastCount = document.querySelectorAll('.post-header').length;

    let lastMaxId = (() => {
        const posts = document.querySelectorAll('.post');
        if (!posts.length) return 0;
        return Math.max(...Array.from(posts).map(p => parseInt(p.getAttribute('data-id')) || 0));
    })();

    statusDiv.addEventListener('click', () => {
        if (isRunning) {
            stopChecking();
        } else {
            if (document.querySelector('[data-userid="Thread"]')) {
                statusDiv.textContent = '[停止中] スレッド完了';
                return;
            }
            startChecking();
        }
    });

    if (autoStart) {
        if (document.querySelector('[data-userid="Thread"]')) {
            statusDiv.textContent = '[停止中] スレッド完了';
        } else {
            startChecking();
        }
    }

    const quickReply = document.getElementById('quick-reply');
    if (quickReply) quickReply.style.marginTop = QUICK_REPLY_MARGIN;

    function styleExistingPosts() {
        const headers = document.querySelectorAll('.post-header');
        const contents = document.querySelectorAll('.post-content');

        headers.forEach(header => {
            if (!(header.previousElementSibling && header.previousElementSibling.classList.contains('existing-top-margin'))) {
                const spacer = document.createElement('div');
                spacer.className = 'existing-top-margin';
                spacer.style.height = EXISTING_TOP_MARGIN_HEIGHT + 'px';
                spacer.style.width = '100%';
                spacer.style.pointerEvents = 'none';
                header.parentNode.insertBefore(spacer, header);
            }
        });

        contents.forEach(content => {
            content.style.paddingBottom = EXISTING_BOTTOM_PADDING_SIZE;
            content.style.marginBottom = '0';
        });
    }

    styleExistingPosts();

    function getUpdateInterval() {
        return timer * 1000;
    }

    async function checkNewPosts() {
        if (!isRunning) return;

        try {
            const baseUrlMatch = location.href.match(/^(https?:\/\/[^\/]+\/test\/read\.cgi\/[^\/]+\/\d+)(\/.*)?$/);
            if (!baseUrlMatch) throw new Error('URL構造が想定外です');

            const fetchUrl = `${baseUrlMatch[1]}/${lastMaxId + 1}-n`;
            const response = await fetch(fetchUrl, { cache: 'no-store' });

            if (response.status === 404) {
                statusDiv.textContent = `[稼働中] 新着なし（最新ID: ${lastMaxId}）`;
                return;
            }

            if (!response.ok) throw new Error(`HTTP ${response.status}`);

            const buffer = await response.arrayBuffer();
            const decoder = new TextDecoder('shift-jis');
            const html = decoder.decode(buffer);

            const parser = new DOMParser();
            const doc = parser.parseFromString(html, 'text/html');

            const newPosts = Array.from(doc.querySelectorAll('.post'));

            if (newPosts.length === 0) {
                statusDiv.textContent = `[稼働中] 新着なし（最新ID: ${lastMaxId}）`;
                return;
            }

            const threadContent = document.getElementById('threadcontent');
            if (!threadContent) throw new Error('#threadcontentが見つかりません');

            const normalPosts = Array.from(threadContent.querySelectorAll('.post:not(.popup-origin)'));
            let insertAfter = normalPosts.length ? normalPosts[normalPosts.length - 1] : null;

            for (const post of newPosts) {
                const postId = parseInt(post.getAttribute('data-id')) || 0;
                if (postId <= lastMaxId) continue;

                const clonedPost = post.cloneNode(true);
                clonedPost.setAttribute('data-date', 'NG');

                if (insertAfter) {
                    insertAfter.after(clonedPost);
                } else {
                    threadContent.appendChild(clonedPost);
                }
                insertAfter = clonedPost;

                const header = clonedPost.querySelector('.post-header');
                const content = clonedPost.querySelector('.post-content');

                if (header && !(header.previousElementSibling && header.previousElementSibling.classList.contains('new-top-margin'))) {
                    const spacer = document.createElement('div');
                    spacer.className = 'new-top-margin';
                    spacer.style.height = NEW_TOP_MARGIN_HEIGHT + 'px';
                    spacer.style.width = '100%';
                    spacer.style.pointerEvents = 'none';
                    header.parentNode.insertBefore(spacer, header);
                }

                if (content) {
                    content.style.paddingBottom = NEW_BOTTOM_PADDING_SIZE;
                    content.style.marginBottom = '0';
                }

                lastMaxId = postId;
                lastCount++;
            }

            if (newPosts.some(p => p.getAttribute('data-userid') === 'Thread')) {
                stopChecking();
                statusDiv.textContent = '[停止中] スレッド完了';
                return;
            }

            statusDiv.textContent = `[稼働中] 新着 ${newPosts.length}件（最新ID: ${lastMaxId}）`;

        } catch (e) {
            console.error("[5ch 新着チェッカー] エラー:", e);
            statusDiv.textContent = `[稼働中] エラー: ${e.message}`;
        }
    }
    window.check5chNewPosts = checkNewPosts;

    function startChecking() {
        if (isRunning) return;
        isRunning = true;
        statusDiv.textContent = '[稼働中]';
        checkNewPosts();
        timerId = setInterval(checkNewPosts, getUpdateInterval());
    }

    function stopChecking() {
        if (!isRunning) return;
        isRunning = false;
        clearInterval(timerId);
        statusDiv.textContent = '[自動更新停止中]';
    }

    document.addEventListener('click', function (e) {
        const target = e.target.closest('a.newpb');
        if (target) {
            e.preventDefault();
            checkNewPosts();
            target.textContent = '読み込み中...';
            setTimeout(() => {
                target.textContent = '新着レスの表示';
            }, 1500);
        }
    });

})();
